//---------------------------------------------------------------------------
///	@file
///		HandModbus.h
///	@brief
///		for ROS package
///	@attention
///		Copyright (C) 2019 - SHINANO-KENSHI Co,Ltd
///	@author
///		7049
//---------------------------------------------------------------------------
/*
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *   * Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *   * Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *   * Neither the name, the copyright and the trademark of the SHINANO-KENSHI
 *     CO.,LTD. nor the names of its contributors may be used to endorse or
 *     promote products derived from this software without specific prior
 *     written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef HAND_MODBUS_H_
#define HAND_MODBUS_H_

#include "IHandComm.h"
#include "ISerial.h"
#include "Modbus.h"

class HandModbus : public IHandComm
{
private:
	Modbus* mModbus;
	UINT8 mSlaveID;

public:
	HandModbus(ISerial* serial);
	virtual ~HandModbus(void);

public:
	INT open(const char* portName, INT baudRate, INT dataBits, INT parity, INT stopBits);
	INT close(void);

public:
	BOOL isOpen(void);
	INT setSlaveID(INT id);

public:
	INT sendPortNumbers(int* dataDio);
	INT recvPortNumbers(int* dataDio);

public:
	INT sendHandServoOff(void);
	INT sendHandServoOn(void);
	INT sendHandStart(INT num);
	INT sendHandStop(void);
	INT sendHandAlarmReset(void);

public:
	INT recvHandAlarm(UINT32* bits);
	INT recvHandWarning(UINT32* bits);
	INT recvHandStatus(UINT32* bits);

public:
	INT recvHandCurrentPosition(INT* posPermill);
	INT recvHandCurrentTorque(INT* trqPermill);
	INT recvHandCurrentThermistor(INT* celsius);
	INT recvHandCurrentEncoder(INT* encPulse);

public:
	INT sendParamPositioning(INT num, const HandParamPartial* pParam);
	INT recvParamPositioning(INT num, const HandParamPartial* pParam);

public:
	INT sendMemoryWrite(INT accessID);
};

#endif /* HAND_MODBUS_H_ */
