//---------------------------------------------------------------------------
///	@file
///		IHandComm
///	@brief
///		for ROS package
///	@attention
///		Copyright (C) 2019 - SHINANO-KENSHI Co,Ltd
///	@author
///		7049
//---------------------------------------------------------------------------
/*
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *   * Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *   * Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *   * Neither the name, the copyright and the trademark of the SHINANO-KENSHI
 *     CO.,LTD. nor the names of its contributors may be used to endorse or
 *     promote products derived from this software without specific prior
 *     written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef	IHANDCOMM_HEADER_INCLUDE
#define	IHANDCOMM_HEADER_INCLUDE

#include "shinanodef.h"

class HandParamPartial
{
public:
	INT orderPos;
	INT orderMsec;
	INT orderTrq;
	INT pushWidth;
	INT pushSpd;
	INT pushPow;
	INT gripErrLower;
	INT gripErrUpper;
	INT areaSigLower;
	INT areaSigUpper;
public:
	HandParamPartial(void)
	{
		orderPos = 1000;
		orderMsec = 1000;
		orderTrq = 800;
		pushWidth = 0;
		pushSpd = 0;
		pushPow = 0;
		gripErrLower = 0;
		gripErrUpper = 0;
		areaSigLower = 0;
		areaSigUpper = 0;
	}
};

class IHandComm
{
public:
	virtual ~IHandComm()
	{
	}

public:
	virtual INT open(const char* portName, INT baudRate, INT dataBits, INT parity, INT stopBits) = 0;
	virtual INT close(void) = 0;

public:
	virtual BOOL isOpen(void) = 0;
	virtual INT setSlaveID(INT id) = 0;

public:
	virtual INT sendPortNumbers(INT* dataDio) = 0;
	virtual INT recvPortNumbers(INT* dataDio) = 0;

public:
	virtual INT sendHandServoOff(void) = 0;
	virtual INT sendHandServoOn(void) = 0;
	virtual INT sendHandStart(INT num) = 0;
	virtual INT sendHandStop(void) = 0;
	virtual INT sendHandAlarmReset(void) = 0;

public:
	virtual INT recvHandAlarm(UINT32* bits) = 0;
	virtual INT recvHandWarning(UINT32* bits) = 0;
	virtual INT recvHandStatus(UINT32* bits) = 0;

public:
	virtual INT recvHandCurrentPosition(INT* posPermill) = 0;
	virtual INT recvHandCurrentTorque(INT* trqPermill) = 0;
	virtual INT recvHandCurrentThermistor(INT* celsius) = 0;
	virtual INT recvHandCurrentEncoder(INT* encPulse) = 0;

public:
	virtual INT sendParamPositioning(INT num, const HandParamPartial* pParam) = 0;
	virtual INT recvParamPositioning(INT num, const HandParamPartial* pParam) = 0;

public:
	virtual INT sendMemoryWrite(INT accessID) = 0;
};

#endif	// IHANDCOMM_HEADER_INCLUDE
