//---------------------------------------------------------------------------
///	@file
///		RobotARH.h
///	@brief
///		for ROS package
///	@attention
///		Copyright (C) 2019 - SHINANO-KENSHI Co,Ltd
///	@author
///		7049
//---------------------------------------------------------------------------
/*
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *   * Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *   * Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *   * Neither the name, the copyright and the trademark of the SHINANO-KENSHI
 *     CO.,LTD. nor the names of its contributors may be used to endorse or
 *     promote products derived from this software without specific prior
 *     written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef ROBOTARH_H_
#define ROBOTARH_H_

#include "IHandComm.h"

class HandDioCode
{
public:
	//input signal
	static const INT iSRVON = 0;
	static const INT iHOME = 1;
	static const INT iDRIVE = 2;
	static const INT iSTOP = 3;
	static const INT iALMRST = 4;
	static const INT iSEL0 = 5;
	static const INT iSEL1 = 6;
	static const INT iSEL2 = 7;

public:
	//output signal
	static const INT iSRV = 256;
	static const INT iREADY = 257;
	static const INT iALARM = 258;
	static const INT iGRIPERR = 259;
	static const INT iAREA = 260;
};

class HandOpeCode
{
public:
	static const INT opeSrvOff = 0x00;
	static const INT opeSrvOn = 0x80;
	static const INT opeHandMove = 0x90;
	//static const INT opeHandMove01 = 0x91;
	//...
	//static const INT opeHandMove15 = 0x9F;
	static const INT opeHandStop = 0xA0;
	static const INT opeHome = 0xC0;
};

class HandStatusCode
{
public:
	static const UINT32 bitSrvOn   = 0x00000001;
	static const UINT32 bitReady   = 0x00000002;
	static const UINT32 bitAlarm   = 0x00000004;
	static const UINT32 bitGripErr = 0x00000008;
	static const UINT32 bitMemRdy  = 0x00000020;
	static const UINT32 bitAreaIn  = 0x00000040;
	static const UINT32 bitHomeOk  = 0x00000080;
};

class RobotARH
{
public:
	RobotARH(void);
	virtual ~RobotARH(void);

private:
	IHandComm* mIHC;
public:
	void setIHandComm(IHandComm* pI);

public:
	static const INT stateNG = -1;
	static const INT stateOK = 0;
	static const INT stateBusy = 1;

private:
	std::string mNameFd;
	INT mBaudrate;
	INT mSlaveID;
	INT mNumDio1;
	INT mNumDio2;
	INT mNumDio3;
	INT mNumDio4;

private:
	HandParamPartial mCParamPart;

public:
	INT openComm(std::string fdname);
	INT setBaudrate(INT baudrate);
	INT setSlaveID(INT slaveid);
	std::string getCommPortName(void);
	INT getBaudrate(void);
	INT getSlaveID(void);

public:
	INT loadPorts(void);
	INT savePorts(void);

public:
	INT getDio1(void) const;
	INT getDio2(void) const;
	INT getDio3(void) const;
	INT getDio4(void) const;
	void setDio1(INT portnum);
	void setDio2(INT portnum);
	void setDio3(INT portnum);
	void setDio4(INT portnum);

public:
	void setHandPos(INT position);
	void setHandTime(INT msec);
	void setHandTrq(INT torque);
	void setHandPosGripErrorLower(INT position);
	void setHandPosGripErrorUpper(INT position);
	void setHandPushPos(INT position);
	void setHandPushSpd(INT speed);
	void setHandPushTrq(INT torque);

public:
	INT opeHand(INT opecode) const;
	INT updtHand(INT partnum) const;

public:
	INT getHandStatus(UINT32* status) const;

public:
	INT writeMemoryCommon(void) const;

public:
	INT getHandCurrentPosition(void) const;
	INT getHandCurrentTorque(void) const;
	INT getHandCurrentThermistor(void) const;
	INT getHandCurrentEncoder(void) const;

public:
	BOOL isHandStatusAlarm(void) const;
	BOOL isHandStatusGripError(void) const;
	BOOL isHandStatusReady(void) const;

private:
	static const UINT32 WaitTimeoutSec = 10;
	static const UINT32 WaitSleepMsec = 50;
	UINT32 mClockStart;
	UINT32 mClockNow;
private:
	void clearTimeout(void);
	BOOL isTimeout(UINT32 sec);
	void sleep(UINT32 msec);

private:
	static const INT movePartNum = 8; //part.8
public:
	INT moveHand(INT position, BOOL isWait);
	INT moveHand(INT position, INT torque, BOOL isWait);
	INT stopHand(void);
private:
	INT moveHandParamSet(INT position);
	INT moveHandParamSet(INT position, INT torque);
	INT moveHandStart(void);
	INT moveHandStop(void);
	INT moveHandWait(BOOL isWait);
	INT calcMoveTarget(HandParamPartial* params, INT position, BOOL isPush);
	BOOL isReqPushIn(HandParamPartial* params);
};

#endif /* ROBOTARH_H_ */
