//---------------------------------------------------------------------------
///	@file
///		aspina_hand_test
///	@brief
///		ASPINA robotic gripper test node
///	@attention
///		Copyright (C) 2020 - SHINANO-KENSHI Co,Ltd
///	@author
///		7022
//---------------------------------------------------------------------------
/*
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *   * Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *   * Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *   * Neither the name, the copyright and the trademark of the SHINANO-KENSHI
 *     CO.,LTD. nor the names of its contributors may be used to endorse or
 *     promote products derived from this software without specific prior
 *     written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "AspinaHand.h"
#include "LibCmd.h"

// メイン
int main(int argc, char **argv)
{
	// パラメータチェック
	bool topic = false;
	int hand_number = 1;
	CmdOption option(argc, argv);
	bool illegal = false;
	for (;;){
		char *ret;
		bool isOption;
		ret = option.Get(&isOption);
		if (ret == NULL){
			break;
		}
		else{
			if (isOption == true){
				if (*ret == 'h' || *ret == 'H'){
					ret = option.Get(&isOption);
					if (ret == NULL || isOption == true){
						illegal = true;
						break;
					}
					else{
						hand_number = atoi(ret);
						if (hand_number < 1 || hand_number > 254){
							illegal = true;
							break;
						}
						else{
							// do nothing
						}
					}
					continue;
				}
				if (*ret == 't' || *ret == 'T'){
					topic = true;
					continue;
				}
			}
			else{
				illegal = true;
				break;
			}
		}
	}
	if (illegal == true){
		printf("illegal command.\n");
		return -1;
	}
	printf("aspina_hand_test : [Number of hand %d , %s]\n", hand_number, topic == true ? "Topic Mode" : "Service Mode");

	// ROS初期化
	// ※init→NodeHandle→Rateの順番厳守。
	argc = 1;
	ros::init(argc, argv, "aspina_hand_test");
	ros::NodeHandle n;
	ros::Rate loop_rate(1000);

	if (topic == false){
		// ROSサービスによる制御
		AspinaHandService service(&n);
		while (ros::ok()){
			AspinaHandService::STATUS sts;
			for (int i = 0; i < hand_number; i++){
				int id = i + 1;
				if (service.GetStatus(id, &sts) == true){
					if (sts.stalled == false && sts.reached_goal == true){
						int pos;
						if (sts.position < 500){
							pos = 1000;
						}
						else{
							pos = 0;
						}
						if (service.Action(id, pos, 1000, 250, false) == false){
							printf("service Action error (%d)\n", id);
							return -1;
						}
						else{
							// do nothing
						}
					}
					else{
						// do nothing
					}
				}
				else{
					printf("service GetStatus error (%d)\n", id);
					return -1;
				}
			}
			loop_rate.sleep();
		}
	}
	else{
		// ROSトピックによる制御
		AspinaHandTopic topic(&n, hand_number);
		if (topic.Startup(1) == true){
			printf("Startup done.\n");
		}
		else{
			printf("Startup fail.\n");
			return -1;
		}
		// メインループ
		while (ros::ok()){
			AspinaHandTopic::STATUS sts;
			for (int i = 0; i < hand_number; i++){
				int id = i + 1;
				int ret = topic.GetStatus(id, &sts, false);
				if (ret == 0){
					if (sts.stalled == false && sts.reached_goal == true){
						int pos;
						if (sts.position < 500){
							pos = 1000;
						}
						else{
							pos = 0;
						}
						if (topic.Action(id, pos, 1000, 250, true) == false){
							printf("topic Action error (%d)\n", id);
							return -1;
						}
						else{
							// do nothing
						}
					}
					else{
						// do nothing
					}
				}
				else{
					if (ret < 0){
						printf("topic GetStatus error (%d)\n", id);
						//return -1;
					}
					else{
						// do nothing
					}
				}
			}
			ros::spinOnce();
			loop_rate.sleep();
		}
	}

	return 0;
}
